﻿/*********************************************************************************
// This code is created by SimCoder Version 2021a0.5 for F28004x Hardware Target
//
// SimCoder is copyright by Powersim Inc., 2009-2021
//
// Date: July 22, 2022 01:46:11
**********************************************************************************/
#include	<math.h>
#include	"PS_bios.h"
#define	GetCurTime() PS_GetSysTimer()
typedef interrupt void (*ClaIntr)(void);
ClaIntr Cla1Task1 = 0;
ClaIntr Cla1Task2 = 0;
ClaIntr Cla1Task3 = 0;
ClaIntr Cla1Task4 = 0;
ClaIntr Cla1Task5 = 0;
ClaIntr Cla1Task6 = 0;
ClaIntr Cla1Task7 = 0;
ClaIntr Cla1Task8 = 0;




interrupt void Task();
interrupt void Task_1();
void TaskS1(DefaultType fIn0, DefaultType *fOut0, DefaultType *fOut1);

#ifdef _FLASH
#pragma DATA_SECTION(PSK_SysClk, "copysections")
#endif
const Uint16 PSK_SysClk = 100;  // MHz
extern	DefaultType	fGblVcnt;
extern	DefaultType	fGblS1_CAPT1;
extern	DefaultType	fGblS1_Vstate;
extern	DefaultType	fGblS1_V2;
extern	DefaultType	fGblS1_V3;






DefaultType	fGblVcnt = 0;
interrupt void Task()
{
	DefaultType	fZOH2, fVSQ1;

	PSM_Timer1IntrEntry();

	{
		static DefaultType wt = 1.0 - ((-90) / 360.);
		static DefaultType dwt = 2 * 1.0 / 10000;
		fVSQ1 = (wt < 0.8) ? ((1) + (0)) : (0);
		wt += dwt;
		if (wt >= 1.0)
			wt -= 1.0;
	}
	fZOH2 = fVSQ1;
	PSM_GpioSetOutput(0, fZOH2 > 0.3 ? 1 : 0);
}

interrupt void Task_1()
{
	DefaultType	fFunVar4, fFunVar3, fF004x_CAP1;

	PSM_CapEntryIntr();

	fF004x_CAP1 = PSM_CapGetCurCount(1) * (1.0/100);
#ifdef	_DEBUG
	fGblVcnt = fF004x_CAP1;
#endif
	TaskS1(fF004x_CAP1, &fFunVar3, &fFunVar4);

	PSM_GpioSetOutput(23, fFunVar3 > 0.3 ? 1 : 0);
	PSM_GpioSetOutput(34, fFunVar4 > 0.3 ? 1 : 0);
	PSM_CapExitIntr(1);
}

DefaultType	fGblS1_CAPT1 = 0;
DefaultType	fGblS1_Vstate = 0;
int32	nGblS1_C_BUFFER_12 = 0;
DefaultType	aryS1_C_BUFFER_12[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
DefaultType	fGblS1_V2 = 0;
int32	nGblS1_C_BUFFER_13 = 0;
DefaultType	aryS1_C_BUFFER_13[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
DefaultType	fGblS1_V3 = 0;
void TaskS1(DefaultType fIn0, DefaultType *fOut0, DefaultType *fOut1)
{
	DefaultType	fS1_C_BUFFER_13, fS1_C_BUFFER_12, fS1_C1;

	fS1_C_BUFFER_12 = aryS1_C_BUFFER_12[nGblS1_C_BUFFER_12];

	fS1_C_BUFFER_13 = aryS1_C_BUFFER_13[nGblS1_C_BUFFER_13];


	fS1_C1 = 500000;
	*fOut0 = (fIn0 > fS1_C1) ? 1 : 0;
	*fOut1 = PSM_CapIsRisingEdge(1);
#ifdef	_DEBUG
	fGblS1_CAPT1 = fIn0;
#endif
#ifdef	_DEBUG
	fGblS1_Vstate = *fOut1;
#endif
	aryS1_C_BUFFER_12[nGblS1_C_BUFFER_12] = fIn0; nGblS1_C_BUFFER_12 = (nGblS1_C_BUFFER_12 >= 100 - 1) ? 0 : (nGblS1_C_BUFFER_12 + 1);
#ifdef	_DEBUG
	fGblS1_V2 = fS1_C_BUFFER_12;
#endif
	aryS1_C_BUFFER_13[nGblS1_C_BUFFER_13] = *fOut1; nGblS1_C_BUFFER_13 = (nGblS1_C_BUFFER_13 >= 100 - 1) ? 0 : (nGblS1_C_BUFFER_13 + 1);
#ifdef	_DEBUG
	fGblS1_V3 = fS1_C_BUFFER_13;
#endif
}


void Initialize(void)
{
	PS_SysInit(2, 20);
	PS_TimerInit(0, 0);
	PS_CapInit(6, 1, 0, 2);		// input signal, eCap1, Event filter prescale, Tim difference

	PS_InXBarSetPin(7, 0);		// Use GPIO0 as Input7 X-BAR

	PS_GpioSetFunc(0, 0, eSync1Samp, eGpioOut, 0);
	PS_GpioSetFunc(23, 0, eSync1Samp, eGpioOut, 0);
	PS_GpioSetFunc(34, 0, eSync1Samp, eGpioOut, 0);

	PS_TimerInit(1, 10000L);
	PS_TimerSetIntrVector(1, Task);	// set timer1 interrupt vector
	PS_CapSetIntrVector(1, CAPINTR_EVT1 | CAPINTR_EVT2, Task_1);
	PS_PwmStartStopClock(2);	// start Timer1
}


void main()
{
	Initialize();
	PSM_EnableIntr();   // Enable Global interrupt INTM
	PSM_EnableDbgm();
	for (;;) {
	}
}

